<?php
/* @wordpress-plugin
 * Plugin Name:       Tender SDK Payment Gateway
 * Plugin URI:        https://tender.cash
 * Description:       Crypto payment gateway using Tender JS SDK
 * Version:           1.0.0
 * WC requires at least: 3.0
 * WC tested up to: 9.4
 * Requires Plugins: woocommerce
 * Author:            Tender
 * Author URI:        https://tender.cash
 * Text Domain:       woocommerce-tender-sdk-gateway
 * Domain Path: /languages
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

use Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry;

$active_plugins = apply_filters('active_plugins', get_option('active_plugins'));
if(tender_sdk_is_woocommerce_active()){
	add_filter('woocommerce_payment_gateways', 'add_tender_sdk_payment_gateway');
	function add_tender_sdk_payment_gateway( $gateways ){
		$gateways[] = 'WC_Tender_SDK_Gateway';
		return $gateways;
	}

	add_action('plugins_loaded', 'init_tender_sdk_payment_gateway');
	function init_tender_sdk_payment_gateway(){
		require 'class-woocommerce-tender-sdk-gateway.php';
	}

	add_action( 'plugins_loaded', 'tender_sdk_load_plugin_textdomain' );
	function tender_sdk_load_plugin_textdomain() {
	  load_plugin_textdomain( 'woocommerce-tender-sdk-gateway', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
	}
}

/**
 * @return bool
 */
function tender_sdk_is_woocommerce_active()
{
	$active_plugins = (array) get_option('active_plugins', array());

	if (is_multisite()) {
		$active_plugins = array_merge($active_plugins, get_site_option('active_sitewide_plugins', array()));
	}

	return in_array('woocommerce/woocommerce.php', $active_plugins) || array_key_exists('woocommerce/woocommerce.php', $active_plugins);
}

add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

add_action( 'woocommerce_blocks_loaded',  function () {
    require_once plugin_dir_path(__FILE__). 'blocks/class-tender-sdk-payment-block.php';
    add_action(
        'woocommerce_blocks_payment_method_type_registration',
        function( PaymentMethodRegistry $payment_method_registry ) {
            $payment_method_registry->register( new Tender_SDK_Payment_Block );
        }
    );
});

add_action( 'before_woocommerce_init', function() {
    if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
    }
} );
