const { registerPaymentMethod } = window.wc.wcBlocksRegistry;
const { getSetting } = window.wc.wcSettings;
const { decodeEntities } = window.wp.htmlEntities;
const { createElement } = window.wp.element;

const settings = getSetting( 'tender_sdk_payment_data', {} );

const defaultLabel = decodeEntities( settings.title ) || 'Tender SDK Payment';
const label = createElement(
    'span',
    { style: { display: 'flex', alignItems: 'center' } },
    defaultLabel
);

const Content = () => {
    return decodeEntities( settings.description || 'Pay securely with cryptocurrency using Tender' );
};

const Block_Gateway = {
    name: 'tender_sdk_payment',
    label: label,
    content: createElement( Content ),
    edit: createElement( Content ),
    canMakePayment: () => true,
    ariaLabel: defaultLabel,
    supports: {
        features: settings.supports,
    },
};

registerPaymentMethod( Block_Gateway );
