# Tender SDK Payment Gateway for WooCommerce

A WordPress/WooCommerce payment gateway plugin that integrates the Tender JavaScript SDK for cryptocurrency payments.

## Description

This plugin provides a seamless cryptocurrency payment experience for WooCommerce stores by utilizing the Tender JS SDK (`@tender-cash/agent-sdk-react`). Unlike traditional implementations that use custom HTML forms, this gateway embeds the official Tender React SDK directly into the payment page.

## Features

- **Direct SDK Integration**: Uses the official Tender React SDK for a consistent payment experience
- **Modern Payment Flow**: Leverages React components for a smooth, interactive payment process
- **Multiple Payment Status Handling**: Supports completed, partial, and overpayment scenarios
- **Test & Live Environments**: Easy switching between test and production environments
- **WooCommerce Blocks Compatible**: Full support for the new WooCommerce checkout blocks
- **Automatic Order Management**: Updates order status based on payment completion
- **Secure**: Uses WordPress nonces and secure AJAX for all operations

## Installation

1. Upload the `woocommerce-payment-sdk-gateway` folder to `/wp-content/plugins/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to WooCommerce > Settings > Payments
4. Enable "Tender SDK Payment" and configure your credentials

## Configuration

### Required Settings

- **Access ID**: Your Tender merchant Access ID (get from Tender dashboard)
- **Access Secret**: Your Tender merchant Access Secret (get from Tender dashboard)
- **Agent ID**: Your Tender Agent ID (get from Tender dashboard)
- **Environment**: Choose between Test (staging) or Live (production)

### Optional Settings

- **Title**: The payment method name shown to customers (default: "Pay with Crypto")
- **Description**: Description shown on checkout page

## How It Works

1. Customer selects "Tender SDK Payment" at checkout
2. After placing order, customer is redirected to the Tender payment page
3. The Tender React SDK loads and displays the payment interface
4. Customer selects their preferred cryptocurrency and completes payment
5. SDK sends payment status back to WordPress via AJAX
6. Order status is updated automatically based on payment result:
   - **Completed**: Order marked as paid
   - **Overpayment**: Order completed with note about excess amount
   - **Partial Payment**: Order placed on hold pending full payment
   - **Error/Cancelled**: Customer returned to checkout

## SDK Integration

This plugin uses the Tender Agent SDK React library:
- Package: `@tender-cash/agent-sdk-react`
- Loaded via: CDN (unpkg.com)
- Documentation: See Tender SDK documentation

### SDK Loading

The plugin loads the Tender SDK as an ES module from CDN:

```javascript
import { TenderAgentSdk } from 'https://unpkg.com/@tender-cash/agent-sdk-react@latest/dist/tender-cash-agent-sdk-react.es.js';
```

### SDK Props Used

```javascript
{
  accessId: "YOUR_ACCESS_ID",
  fiatCurrency: "USD",
  env: "test", // or "live"
  amount: 150.00,
  referenceId: "order-123-timestamp",
  paymentExpirySeconds: 1800,
  theme: "light",
  onEventResponse: handlePaymentCallback
}
```

## Development

### File Structure

```
woocommerce-payment-sdk-gateway/
├── woocommerce-tender-sdk-gateway.php    # Main plugin file
├── class-woocommerce-tender-sdk-gateway.php   # Gateway class
├── templates/
│   └── tender-sdk-payment.php            # Payment page template
├── blocks/
│   ├── class-tender-sdk-payment-block.php    # Blocks integration
│   └── build/
│       ├── index.js                      # Block script
│       └── index.asset.php               # Asset dependencies
├── languages/                            # Translation files
└── README.md                             # This file
```

### Hooks & Filters

The plugin registers the following hooks:

- `woocommerce_payment_gateways`: Adds gateway to WooCommerce
- `woocommerce_blocks_payment_method_type_registration`: Registers checkout block
- `wp_ajax_tender_sdk_update_order_status`: Handles payment status updates

### Custom Routes

- `/tender-sdk-payment/?order_id={ID}`: Payment processing page

## Requirements

- WordPress 5.0 or higher
- WooCommerce 3.0 or higher
- PHP 7.4 or higher
- Modern browser with JavaScript enabled

## Security

- All AJAX requests are protected with WordPress nonces
- Access credentials are stored securely in WordPress options
- Order IDs are validated before processing
- Payment data is sanitized before storage

## Support

For issues or questions:
- Plugin Issues: Contact your development team
- Tender SDK Issues: See Tender documentation or support
- WooCommerce Issues: See WooCommerce documentation

## Changelog

### 1.0.0
- Initial release
- Tender React SDK integration
- Support for test and live environments
- WooCommerce Blocks compatibility
- Automatic order status management
- Multi-status payment handling

## License

GPL-2.0+

## Credits

Developed for Tender Cash payment integration.
